<?php

/*

Plugin Name: Easy Order Print Woo

Plugin URI: https://cs-cart-soft.eu

Description: Easy Order Print for WooCommerce - Print your WooCommerce orders automatically to any Thermal printer or to any printer. You need to Download Windows Application. 

Author: devteamsipware

Version: 0.6

Author URI:

License: GPLv2 or later

*/



if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 



// add custom REST API GET endpoint /easyprint/order/<id>

add_action('rest_api_init', function () {

    register_rest_route('easy-order-print-woo', '/orders/(?P<id>\d+)', array(

        'methods' => 'GET',

        'callback' => 'eopfwoocom_update_order',

        'permission_callback' => 'eopfwoocom_authentication_callback',

    ));

});



// update WooCommerce order

function eopfwoocom_update_order($request) {

    $order_id = $request['id'];

    $order = wc_get_order($order_id);



    if (!$order) {

        //echo "NO_ORDER";

        echo "99";

        die; 

    }



    // Attempt to update the order status

    try {

        $order->update_status('completed');

        // $success_response = array(

        //     'message' => 'Order updated successfully.',

        //     'data' => array(

        //         'order_id' => $order_id

        //     )

        // );

        // return new WP_REST_Response($success_response, 200); // Return success with 200 OK status code

        

        //echo "Order_status_has_been_changed";

        echo "88";

        die();

        

    } catch (Exception $e) {

        // $error_response = array(

        //     'message' => 'Failed to update order.',

        //     'data' => array(

        //         'order_id' => $order_id,

        //         'error' => $e->getMessage()

        //     )

        // );

        // return new WP_REST_Response($error_response, 500); // Return error with 500 Internal Server Error status code

        

        //echo "Failed_to_update_order";

        echo "77";

    }

}





// add custom REST API GET endpoint /easy-order-print-woo/orders

add_action('rest_api_init', function () {

    register_rest_route('easy-order-print-woo', '/orders', array(

        'methods' => 'GET',

        'callback' => 'eopfwoocom_get_new_orders',

        'permission_callback' => 'eopfwoocom_authentication_callback',

    ));

});





function eopfwoocom_remove_not_need_symbols($orderdata){

	$newdata = "";

	$newdata = str_replace("*","", $orderdata);

	$newdata = str_replace("~","", $newdata);

	$newdata = str_replace("%","", $newdata);

	$newdata = str_replace("#","", $newdata);

	$newdata = str_replace("&","", $newdata);

	$newdata = str_replace("$","", $newdata);

	$newdata = str_replace("^","", $newdata);

	$newdata = str_replace("{","", $newdata);

	$newdata = str_replace("}","", $newdata);

	

	return $newdata; 

}





function eopfwoocom_get_new_orders() {

	$string_to_send = "";

   	//Request orders

  	//Order status: pending, processing,on-hold,completed,cancelled,refunded,failed,trash

    

    // Get pending orders from woocommerce

    $orders = wc_get_orders(array(

        'status' => 'processing',

    ));

    

    if (empty($orders)) {

        //echo "NO_ORDER";

        echo "99";

        die;

    }

    

    

    $string_to_send = '';

    //foreach ($orders as $order){

    $order_arr = $orders[0]->get_data();



    

    //---Debug----

    //echo "<pre>";
    //print_r($order_arr);
    //echo "</pre>"; 

        

    

    $order_id = trim($order_arr['id']);

    $string_to_send .= "#" .$order_id;

            

  

        

    foreach($order_arr['line_items'] as $prod){
    	$name = $prod['name'];
        $name = eopfwoocom_remove_not_need_symbols($name);
        $quantity = $prod['quantity'];
        $product_cost = $prod['total'];
        $string_to_send .= "*" . $name . "~" . $quantity . "~";
        $metadata = $prod->get_meta_data(); 
        $number_of_product_options = sizeof($metadata);
        $string_to_send .= $number_of_product_options."~".$product_cost."~";

         /*
         echo '-----Debug-----';
         echo "<pre>";
         print_r($metadata);
         echo "</pre>";
         echo "----------------------------<br>";
         echo $number_of_product_options;
         echo '-----Debug End-----';           
         */

         foreach ($metadata as $row){
         	 $option_arr = $row->get_data();
             //echo "<br>".$option_arr['key']. "==>>".$option_arr['value'];   
             $option_name = $option_arr['key'];
             $option_name = eopfwoocom_remove_not_need_symbols($option_name);
             $option_value = $option_arr['value'];
             $option_value = eopfwoocom_remove_not_need_symbols($option_value);
             $string_to_send .= $option_name . "~" . $option_value . "~";
          }       
       }

               

       // Get Shipping Address
       $string_to_send .= "%";
       $shipping_address = $order_arr['shipping'];
       $phone_number_from_billing_fields = $order_arr['billing']['phone'] ; // We get the phone from billing fields i case it missing from billing fields


       foreach ($shipping_address as $key => $value) {
           If ($key == "phone" && empty($value)){
           	   $value = $phone_number_from_billing_fields; 
           }
       	   if (($value == "M") || ($value == "GR") || ($value == "ES") || ($value == "EN") ) {   // Some Custom Filter of Shipping Address

       	      $value=" "; //space
       	   }

       	   $string_to_send .= eopfwoocom_remove_not_need_symbols($value) . "&";

       

       }



       

       $string_to_send = rtrim($string_to_send, "&");

       $string_to_send .= "%";

             

       $string_to_send .= "$";

              

       // Get Payment method

       $payment_method = $order_arr['payment_method'];

       $payment_method = eopfwoocom_remove_not_need_symbols($payment_method);

       $payment_method_title = $order_arr['payment_method_title'];

       $payment_method_title = eopfwoocom_remove_not_need_symbols($payment_method_title);

        

       if (empty($payment_method)) {

            $payment_method = "No value";

       }

       if (empty($payment_method_title)) {

           $payment_method_title = "No Value";

       }

       

       $string_to_send .= $payment_method . "~" . $payment_method_title . "$";

        

      //--- Extra Values  
      // First is Always Order Fees in Case there
      $extra_value_info = "Order-Fee-Info";

      //$extra_value_data = "0.0";
      $extra_value_data = $order_arr['shipping_total'];
      $extra_value_data = number_format((float)$extra_value_data, 2, '.', '');
      $extra_value_info =  eopfwoocom_remove_not_need_symbols($extra_value_info);
      $extra_value_data =  eopfwoocom_remove_not_need_symbols($extra_value_data); 
      $string_to_send = $string_to_send."^".$extra_value_info."^".$extra_value_data."^";
     

      // ORDER DISCOUNT
      $extra_value_info = "Order-Discount-Info";
      $extra_value_data =  $order_arr['discount_total'];
      //$extra_value_data = "5.3";
      $extra_value_data = number_format((float)$extra_value_data, 2, '.', '');
      $extra_value_info =  eopfwoocom_remove_not_need_symbols($extra_value_info);
      $extra_value_data =  eopfwoocom_remove_not_need_symbols($extra_value_data); 
      $string_to_send = $string_to_send.$extra_value_info."^".$extra_value_data."^" ;

      //SHIPPING METHOD - TITLE
      foreach($order_arr['shipping_lines'] as $ship){
          $shippping_method_title = $ship['method_title'];
      	  //echo "<br>".$shippping_method_title."<br>";
      }
      $extra_value_info = "Selected-Shipping-Method";
      $extra_value_data = $shippping_method_title; 
      $extra_value_data =  eopfwoocom_remove_not_need_symbols($extra_value_data); 
      $string_to_send = $string_to_send.$extra_value_info."^".$extra_value_data."^" ;
         
      
      

      $string_to_send = $string_to_send."Description 1"."^"."Value 1"."^" ;

       // Get Customer note

       $customer_note = $order_arr['customer_note'];

       $customer_note = eopfwoocom_remove_not_need_symbols($customer_note);

        

       if (empty($customer_note)) {

            $customer_note = " ";

       }

  

       $string_to_send = count($order_arr['line_items']) . $string_to_send . "~" . $customer_note . "~";

    

       

       //echo $string_to_send;

       echo esc_html($string_to_send);

              



}



// callback to ensure the caller has a valid Bearer Token

function eopfwoocom_authentication_callback($request) {

  

	

	// Check if the current user has a valid bearer token

    $token = $request->get_header('Authorization');

    // echo "Received Token ==>".$token."<br>";

   

    if (!$token || !preg_match('/Bearer\s(\S+)/', $token, $matches)) {

        return new WP_Error('rest_forbidden', esc_html__('401'), array('status' => 401));

    }



    

    // Here you validate the token against your authentication mechanism

    // retrieve value from options

    $eopfwoocom_easyprint_options = get_option( 'eopfwoocom_easyprint_option_name' ); // Array of All Options

	$eopfwoocom_api_token_0 = $eopfwoocom_easyprint_options['eopfwoocom_api_token_0']; // API Token

	

	$token = str_replace("Bearer","",$token);

	$token = trim($token);

	

	

	if ($token == $eopfwoocom_api_token_0) {

	    $valid_token = true;

    }



    

    

    if (!$valid_token) {

        return new WP_Error('rest_forbidden', esc_html__('401'), array('status' => 401));

    }



    // Token is valid, return true to allow access to the endpoint

    return true;

}





/**

 * Plugin options page (found under Settings)

 * Generated by the WordPress Option Page generator

 * at http://jeremyhixon.com/wp-tools/option-page/

 */

class EOPFWOOCOM_EasyPrint {

	private $eopfwoocom_easyprint_options;



	public function __construct() {

		add_action( 'admin_menu', array( $this, 'eopfwoocom_easyprint_add_plugin_page' ) );

		add_action( 'admin_init', array( $this, 'eopfwoocom_easyprint_page_init' ) );

		

		// Call activation hook to initialize options upon plugin activation

        register_activation_hook( __FILE__, array( $this, 'eopfwoocom_easyprint_plugin_activation' ) );

    }

    

    //function to run upon plugin activation

    public function eopfwoocom_easyprint_plugin_activation() {

        // Generate a random string for eopfwoocom_api_token_0

        $api_token = wp_generate_password( 32, false );



        // Initialize options array

        $eopfwoocom_easyprint_options = array(

            'eopfwoocom_api_token_0' => $api_token

            // Add more options here if needed

        );



        // Add the options to the database

        add_option( 'eopfwoocom_easyprint_option_name', $eopfwoocom_easyprint_options );

    }

	



	public function eopfwoocom_easyprint_add_plugin_page() {

		add_options_page(

			'Easy Order Print Woo', // page_title

			'Easy Order Print Woo', // menu_title

			'manage_options', // capability

			'easy-order-print-woo', // menu_slug

			array( $this, 'eopfwoocom_easyprint_create_admin_page' ) // function

		);

	}



	public function eopfwoocom_easyprint_create_admin_page() {

		$this->eopfwoocom_easyprint_options = get_option( 'eopfwoocom_easyprint_option_name' ); ?>



		<div class="wrap">

			<h2>Easy Order Print for WooCommerce</h2>

			<p></p>

			<?php settings_errors(); ?>



			<form method="post" action="options.php">

				<?php

					settings_fields( 'eopfwoocom_easyprint_option_group' );

					do_settings_sections( 'eopfwoocom_easyprint-admin' );

					submit_button();

				?>

			</form>

		</div>

	<?php }



	public function eopfwoocom_easyprint_page_init() {

		register_setting(

			'eopfwoocom_easyprint_option_group', // option_group

			'eopfwoocom_easyprint_option_name', // option_name

			array( $this, 'eopfwoocom_easyprint_sanitize' ) // sanitize_callback

		);



		add_settings_section(

			'easyprint_setting_section', // id

			'Settings', // title

			array( $this, 'eopfwoocom_easyprint_section_info' ), // callback

			'eopfwoocom_easyprint-admin' // page

		);



		add_settings_field(

			'eopfwoocom_api_token_0', // id

			'API Token', // title

			array( $this, 'eopfwoocom_api_token_0_callback' ), // callback

			'eopfwoocom_easyprint-admin', // page

			'easyprint_setting_section' // section

		);

	}



	public function eopfwoocom_easyprint_sanitize($input) {

		$sanitary_values = array();

		if ( isset( $input['eopfwoocom_api_token_0'] ) ) {

			$sanitary_values['eopfwoocom_api_token_0'] = sanitize_text_field( $input['eopfwoocom_api_token_0'] );

		}



		return $sanitary_values;

	}



	public function eopfwoocom_easyprint_section_info() {

		

	}



	public function eopfwoocom_api_token_0_callback() {

    	// Get the saved API token value from options, or generate a random string as default

    	$api_token = isset($this->eopfwoocom_easyprint_options['eopfwoocom_api_token_0']) ? esc_attr($this->eopfwoocom_easyprint_options['eopfwoocom_api_token_0']) : wp_generate_password(32, false);



	    printf(

    	    '<input class="regular-text" type="text" name="eopfwoocom_easyprint_option_name[eopfwoocom_api_token_0]" id="eopfwoocom_api_token_0" value="%s">',

        	esc_html($api_token)

    	);

	}



} // of class EasyPrint



if ( is_admin() )

	$eopfwoocom_easyprint = new EOPFWOOCOM_EasyPrint();



?>